local slowmo = {}
slowmo.scale = 100
slowmo.slow = false
slowmo.active = "Inactive"
slowmo.hide = false
slowmo.cd = 0

function slowmo.unload()
	GAMEPLAY.SET_TIME_SCALE(1)
end

function slowmo.init()

end


function slowmo.tick()
	slowmo.drawGUI()
	slowmo.cd = slowmo.cd - 1
	if(get_key_pressed(Keys.J)) and slowmo.cd < 1 then
		slowmo.cd=5
		if not slowmo.slow then
			slowmo.run()
			slowmo.slow = true
			slowmo.active = "Active"
		else
			slowmo.unload()
			slowmo.slow = false
			slowmo.active = "Inactive"
		end
	elseif(get_key_pressed(Keys.Add)) and slowmo.cd < 1 then
		slowmo.cd=5
		slowmo.scale = slowmo.scale - 5;
		if slowmo.scale < 0 then
			slowmo.scale = 0
		end
		if slowmo.slow then
			slowmo.run()
		end
	elseif(get_key_pressed(Keys.Subtract)) and slowmo.cd < 1 then
		slowmo.cd=5
		slowmo.scale = slowmo.scale + 5;
		if slowmo.scale > 100 then
			slowmo.scale = 100
		end
		if slowmo.slow then
			slowmo.run()
		end
	elseif(get_key_pressed(Keys.F5)) then
		if not slowmo.hide then
			slowmo.hide = true
		else
			slowmo.hide = false
		end
	end
end

function slowmo.run()
	GAMEPLAY.SET_TIME_SCALE(slowmo.scale / 100)
end

function  slowmo.drawGUI()
	if not slowmo.hide then
		UI.SET_TEXT_FONT(0)
		UI.SET_TEXT_SCALE(0.0, 0.35)
		if slowmo.scale > 5 then
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
		elseif slowmo.scale > 0 then
			UI.SET_TEXT_COLOUR(255, 255, 0, 255)
		else
			UI.SET_TEXT_COLOUR(255, 0, 0, 255)
		end
		UI.SET_TEXT_CENTRE(true)
		UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
		UI.SET_TEXT_EDGE(0, 0, 0, 0, 0)
		UI._SET_TEXT_ENTRY("STRING")
		UI._ADD_TEXT_COMPONENT_STRING("Slowmo: "..slowmo.scale.." %")
		UI._DRAW_TEXT(0.5, 0.005)
		
		UI.SET_TEXT_FONT(0)
		UI.SET_TEXT_SCALE(0.0, 0.35)
		if slowmo.scale > 5 then
			UI.SET_TEXT_COLOUR(255, 255, 255, 255)
		elseif slowmo.scale > 0 then
			UI.SET_TEXT_COLOUR(255, 255, 0, 255)
		else
			UI.SET_TEXT_COLOUR(255, 0, 0, 255)
		end
		UI.SET_TEXT_CENTRE(true)
		UI.SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0)
		UI.SET_TEXT_EDGE(0, 0, 0, 0, 0)
		UI._SET_TEXT_ENTRY("STRING")
		UI._ADD_TEXT_COMPONENT_STRING(slowmo.active)
		UI._DRAW_TEXT(0.5, 0.02)
		
		GRAPHICS.DRAW_RECT(0.5, 0.025,0.1, 0.05, 0, 255, 255, 75)
	end
end
return slowmo