/*****************************************************************************
*
*  PROJECT:		Multi Theft Auto v1.0
*  LICENSE:		See LICENSE in the top level directory
*  FILE:		sdk/game/CStats.h
*  PURPOSE:		Game statistics interface
*
*  Multi Theft Auto is available from http://www.multitheftauto.com/
*
*****************************************************************************/

#ifndef __CGAME_STATS
#define __CGAME_STATS

#define STATS_OFFSET	    120
#define STATS_BLANK_OFFSET  320

enum {
	/*********************************
	 ALL FLOAT VALUES TO BE ADDED HERE
	 *********************************/
	PROGRESS_MADE = 0,
	TOTAL_PROGRESS,
	
	LONGEST_BASKETBALL,
			
	// distances:
	DIST_FOOT,
	DIST_CAR,
	DIST_BIKE,
	DIST_BOAT,
	DIST_GOLF_CART,
	DIST_HELICOPTOR,
	DIST_PLANE,

	LONGEST_WHEELIE_DIST, // 10
	LONGEST_STOPPIE_DIST,
	LONGEST_2WHEEL_DIST,
	
	// cash:
	WEAPON_BUDGET,
	FASHION_BUDGET,
	PROPERTY_BUDGET,
	SPRAYING_BUDGET,

	// times:
	LONGEST_WHEELIE_TIME,
	LONGEST_STOPPIE_TIME,
	LONGEST_2WHEEL_TIME,
	
	FOOD_BUDGET, // 20
	
	FAT,
	STAMINA,
	BODY_MUSCLE,
	MAX_HEALTH,

	SEX_APPEAL,
	
	// new stats for SA
	DIST_SWIMMING,
	DIST_CYCLE,
	DIST_TREADMILL,
	DIST_EXCERSISE_BIKE,
	
	TATTOO_BUDGET,	// 30
	HAIRDRESSING_BUDGET,
	NOT_USED_FLOAT_6,
	PROSTITUTE_BUDGET,
	NOT_USED_FLOAT_2,
	
	MONEY_SPENT_GAMBLING,
	MONEY_MADE_PIMPING,
	MONEY_WON_GAMBLING,
	BIGGEST_GAMBLING_WIN,
	BIGGEST_GAMBLING_LOSS,
	
	LARGEST_BURGLARY_SWAG, // 40
	MONEY_MADE_BURGLARY,
	
	NOT_USED_FLOAT_3,
	NOT_USED_FLOAT_4,
	
	LONGEST_TREADMILL_TIME,
	LONGEST_EXCERSISE_BIKE_TIME,
	
	HEAVIEST_WEIGHT_BENCH_PRESS,
	HEAVIEST_WEIGHT_DUMBELLS,
	
	BEST_TIME_HOTRING,  
	BEST_TIME_BMX,
	NOT_USED_INT_11,  // 50

	LONGEST_CHASE_TIME,
	LAST_CHASE_TIME,
	
	WAGE_BILL,
	
	STRIP_CLUB_BUDGET,
	CAR_MOD_BUDGET,
	
	TIME_SPENT_SHOPPING,
	NOT_USED_INT_1,
	
	NOT_USED_INT_3,
	NOT_USED_INT_4,
	
	NOT_USED_INT_19,  // 60
	NOT_USED_INT_5,
	TOTAL_SHOPPING_BUDGET,
	
	TIME_SPENT_UNDERWATER,

	RESPECT_TOTAL,
	RESPECT_GIRLFRIEND,
	RESPECT_CLOTHES,
	RESPECT_FITNESS,
	RESPECT,

	WEAPONTYPE_PISTOL_SKILL,  // weapon types	// 69
	WEAPONTYPE_PISTOL_SILENCED_SKILL, 			// 70
	WEAPONTYPE_DESERT_EAGLE_SKILL,				// 71
	WEAPONTYPE_SHOTGUN_SKILL,					// 72
	WEAPONTYPE_SAWNOFF_SHOTGUN_SKILL,			// 73
	WEAPONTYPE_SPAS12_SHOTGUN_SKILL,			// 74
	WEAPONTYPE_MICRO_UZI_SKILL,					// 75
	WEAPONTYPE_MP5_SKILL,						// 76
	WEAPONTYPE_AK47_SKILL,						// 77
	WEAPONTYPE_M4_SKILL,						// 78
	WEAPONTYPE_SNIPERRIFLE_SKILL,				// 79

	SEX_APPEAL_CLOTHES,

	GAMBLING,

	MAX_FLOAT_STATS  // must be last
};


enum {
	/************************************
	 ALL INT/BOOL VALUES TO BE ADDED HERE
	 ************************************/

	PEOPLE_KILLED_BY_OTHERS = STATS_OFFSET,  // 120 starts off at STATS_OFFSET
	PEOPLE_KILLED_BY_PLAYER,
	
	CARS_DESTROYED,
	BOATS_DESTROYED,
	HELICOPTORS_DESTROYED,
	PROPERTY_DESTROYED,

	ROUNDS_FIRED,
	EXPLOSIVES_USED,
	
	BULLETS_HIT,
	TYRES_POPPED,
	HEADS_POPPED, // 130
	
	WANTED_STARS_ATTAINED,
	WANTED_STARS_EVADED,
	TIMES_ARRESTED,

	DAYS_PASSED,
	TIMES_DIED,
	TIMES_SAVED,
	TIMES_CHEATED,

	SPRAYINGS,
	
	MAX_JUMP_DISTANCE,
	MAX_JUMP_HEIGHT, // 140
	MAX_JUMP_FLIPS,
	MAX_JUMP_SPINS,
	
	BEST_STUNT,
	
	UNIQUE_JUMPS_FOUND,
	UNIQUE_JUMPS_DONE,
	
	MISSIONS_ATTEMPTED,
	MISSIONS_PASSED,
	TOTAL_MISSIONS,
	
	TAXI_MONEY_MADE,
	PASSENGERS_DELIVERED_IN_TAXI, // 150
	LIVES_SAVED,
	CRIMINALS_CAUGHT,
	FIRES_EXTINGUISHED,
	PIZZAS_DELIVERED,
	ASSASSINATIONS,
	LATEST_DANCE_SCORE,
	
	VIGILANTE_LEVEL,
	AMBULANCE_LEVEL,
	FIREFIGHTER_LEVEL,
	
	DRIVING_SKILL, // 160
	TRUCK_MISSIONS_PASSED,
	TRUCK_MONEY_MADE,
	
	RECRUITED_GANG_MEMBERS_KILLED,
	ARMOUR,
	ENERGY,

	PHOTOS_TAKEN,
	
	KILL_FRENZIES_ATTEMPTED,
	KILL_FRENZIES_PASSED,
	
	FLIGHT_TIME,
	TIMES_DROWNED, // 170
	NUM_GIRLS_PIMPED,
	
	BEST_POSITION_HOTRING,
	FLIGHT_TIME_JETPACK,
	
	SHOOTING_RANGE_SCORE,
	VALET_CARS_PARKED,
	
	KILLS_SINCE_LAST_CHECKPOINT,
	TOTAL_LEGITIMATE_KILLS,
	
	BLOODRING_KILLS,
	BLOODRING_TIME,
	
	NO_MORE_HURRICANES, // 180
	CITIES_PASSED,
	
	// new stats for SA:
	
	POLICE_BRIBES,
	CARS_STOLEN,
	CURRENT_GIRLFRIENDS,
	BAD_DATES,
	GIRLS_DATED,
	TIMES_SCORED_WITH_GIRL,
	DATES,
	GIRLS_DUMPED,
	TIMES_VISITED_PROSTITUTE,
	HOUSES_BURGLED,
	SAFES_CRACKED,
	NOT_USED_INT_2,
	STOLEN_ITEMS_SOLD,
	EIGHT_BALLS_IN_POOL,
	WINS_IN_POOL,
	LOSSES_IN_POOL,
	VISITS_TO_GYM,
	NOT_USED_INT_6,
	
	MEALS_EATEN, // 200
	
	QUARRY_MONEY_MADE,
	QUARRY_COMPLETION_TIME,
	
	NOT_USED_INT_7,
	NOT_USED_INT_8,
	
	HIGHEST_PED_KILLS_ON_SPREE,
	HIGHEST_POLICE_KILLS_ON_SPREE,
	HIGHEST_CIV_VEHICLES_DESTROYED_ON_SPREE,
	HIGHEST_COP_VEHICLES_DESTROYED_ON_SPREE,
	HIGHEST_TANKS_DESTROYED_ON_SPREE,
	
	PIMPING_LEVEL, // 210
	
	KICKSTART_BEST_SCORE, 
	BEST_LAP_TIME_HOTRING,
	
	VEHICLES_EXPORTED, 
	VEHICLES_IMPORTED, 
	HIGHEST_SCORE_IN_BASKETBALL_CHALLENGE, 
	
	FIRES_STARTED,
	DRUGS_SOLD,
	DRUGS_BOUGHT,
	
	BEST_LAP_TIME_DIRTTRACK,
	BEST_TIME_DIRTTRACK,
	
	BEST_POSITION_DIRTTRACK,
	BEST_TIME_NRG,
	
	FLYING_SKILL,
	
	RESPECT_MISSION,
	UNDERWATER_BREATH_STAMINA,
	
	GORE_RATING_LEVEL,
	SEX_RATING_LEVEL,
	
	RESPECT_MISSION_TOTAL,
	BIKE_SKILL,
	CYCLE_SKILL, // 230
	
	SNAPSHOTS_TAKEN,
	TOTAL_SNAPSHOTS,
	
	LUCK,
	
	TERRITORIES_TAKEN_OVER,
	TERRITORIES_LOST,
	NUMBER_TERRITORIES_HELD,
	HIGHEST_NUMBER_TERRITORIES_HELD,
	NUMBER_GANG_MEMBERS_RECRUITED,
	NUMBER_ENEMY_GANG_MEMBERS_KILLED,
	NUMBER_FRIENDLY_GANG_MEMBERS_KILLED, // 240
	
	HORSESHOES_COLLECTED,
	TOTAL_HORSESHOES,
	OYSTERS_COLLECTED,
	TOTAL_OYSTERS,

	CALORIES,
	
	P2_RAMPAGE_BEST_TIME,
	P2_CARS_RAMPAGE_BEST_TIME,
	P2_PEDS_RAMPAGE_BEST_TIME,
	P2_HELI_RAMPAGE_BEST_TIME,
	P2_BIKE_RAMPAGE_BEST_TIME,
	KEEPIE_UPPY_BEST_TIME,
	
	GIRLFRIEND_DENISE,
	GIRLFRIEND_MICHELLE,
	GIRLFRIEND_HELENA,
	GIRLFRIEND_BARBARA,
	GIRLFRIEND_KATIE,
	GIRLFRIEND_MILLIE,
	
	// race stats:
	RACETOUR_0_BEST_POSITION,
	RACETOUR_0_BEST_TIME,
	RACETOUR_1_BEST_POSITION,
	RACETOUR_1_BEST_TIME,
	RACETOUR_2_BEST_POSITION,
	RACETOUR_2_BEST_TIME,
	RACETOUR_3_BEST_POSITION,
	RACETOUR_3_BEST_TIME,
	RACETOUR_4_BEST_POSITION,
	RACETOUR_4_BEST_TIME,
	RACETOUR_5_BEST_POSITION,
	RACETOUR_5_BEST_TIME,
	RACETOUR_6_BEST_POSITION,
	RACETOUR_6_BEST_TIME,
	RACETOUR_7_BEST_POSITION,
	RACETOUR_7_BEST_TIME,
	RACETOUR_8_BEST_POSITION,
	RACETOUR_8_BEST_TIME,
	RACETOUR_9_BEST_POSITION,
	RACETOUR_9_BEST_TIME,
	RACETOUR_10_BEST_POSITION,
	RACETOUR_10_BEST_TIME,
	RACETOUR_11_BEST_POSITION,
	RACETOUR_11_BEST_TIME,
	RACETOUR_12_BEST_POSITION,
	RACETOUR_12_BEST_TIME,
	RACETOUR_13_BEST_POSITION,
	RACETOUR_13_BEST_TIME,
	RACETOUR_14_BEST_POSITION,
	RACETOUR_14_BEST_TIME,
	RACETOUR_15_BEST_POSITION,
	RACETOUR_15_BEST_TIME,
	RACETOUR_16_BEST_POSITION,
	RACETOUR_16_BEST_TIME,
	RACETOUR_17_BEST_POSITION,
	RACETOUR_17_BEST_TIME,
	RACETOUR_18_BEST_POSITION,
	RACETOUR_18_BEST_TIME,
	RACETOUR_19_BEST_TIME,
	RACETOUR_20_BEST_TIME,
	RACETOUR_21_BEST_TIME,
	RACETOUR_22_BEST_TIME,
	RACETOUR_23_BEST_TIME,
	RACETOUR_24_BEST_TIME,
	
	PASSED_SWEET2,
	PASSED_STRAP3,
	PASSED_ZERO1,
	PASSED_SYNDICATE_AND_WOOZIE,
	PASSED_CASINO7,
	PASSED_HEIST8,
	PASSED_MANSION2,
	STARTED_RIOT1,
	PASSED_RYDER2,
	PASSED_FARLIE3,
	PASSED_HEIST1,
	PASSED_SYNDICATE2,
	PASSED_LAFIN1,
	PASSED_CAT2,
	PASSED_SYNDICATE1,
	PASSED_CASINO4,
	PASSED_CAT1,
	PASSED_BCRASH1,
	PASSED_DESERT1,
	PASSED_GARAGE1,
	PASSED_BCESAR4,
	PASSED_LAFIN2,
	PASSED_GARAGE2,
	PASSED_DESERT4,
	PASSED_DESERT12,
	PASSED_CASINO3,
	PASSED_CASINO6,
	PASSED_CASINO10,
	PASSED_DESERT3,
	PASSED_DESERT5,
	PASSED_DESERT8,
	PASSED_DESERT10,
	PASSED_MANSION3,
	PASSED_RIOT1,
	PASSED_SCRASH1,
	PASSED_STRAP4,
	PASSED_TRUTH2,
	PASSED_VCRASH2,
	STARTED_BADLANDS,
	STARTED_CAT2,
	STARTED_CRASH1,	
	MAX_INT_FLOAT_STATS,  // this must be the last
};

enum {
	//
	// blank stats are ones that have details and are therefore not in the list above
	//
	PLAYING_TIME = STATS_BLANK_OFFSET,
	NOT_USED_BLANK_1,
	NUMBER_TAGS,
	LEAST_FAVORITE_GANG,
	GANG_MEMBERS_WASTED,
	CRIMINALS_WASTED,
	
	MOST_FAVORITE_RADIO_STATION,
	LEAST_FAVORITE_RADIO_STATION,

	CURRENT_WEAPON_SKILL,
	WEAPON_SKILLS,
	
	PILOT_RANKING, // 330
	
	STRONGEST_GANG_1, // 331
	STRONGEST_GANG_2,
	STRONGEST_GANG_3,
	
	MONEY_LOST_GAMBLING,
	HEALTH,
	GANG_MEMBER_COUNT,
	TERRITORY_UNDER_CONTROL,

	MAX_BLANK_STATS  // this is the last in list
	};


//
// ACTION REACTION STATS (used to identify in table array):
//
// IMPORTANT:  If you add/remove anything from this enum make sure
//			   you update AR_STATS.DAT accordingly!
enum {
	//
	// amount to increase/decrease the stats by:
	//
	STAT_INC_CYCLE_STAMINA = 0,
	STAT_INC_SWIM_STAMINA,
	STAT_INC_SPRINT_STAMINA,
	STAT_INC_RUNNING,
	STAT_INC_DRIVING_SKILL,
	STAT_INC_FLYING_SKILL,
	STAT_INC_CYCLE_SKILL,
	STAT_INC_MOTORBIKE_SKILL,
	STAT_INC_BOAT_SKILL,
	STAT_INC_BODY_MUSCLE,
	STAT_INC_BREATH_UNDERWATER,
	STAT_INC_MAX_HEALTH,		// 11
	
	STAT_INC_PISTOL_SKILL, 		// 12
	STAT_INC_PISTOL_SILENCED_SKILL,
	STAT_INC_DESERT_EAGLE_SKILL,
	STAT_INC_SHOTGUN_SKILL,
	STAT_INC_SAWNOFF_SHOTGUN_SKILL,
	STAT_INC_SPAS12_SHOTGUN_SKILL,
	STAT_INC_MICRO_UZI_SKILL,
	STAT_INC_MP5_SKILL,
	STAT_INC_AK47_SKILL,
	STAT_INC_M4_SKILL,
	STAT_INC_SNIPERRIFLE_SKILL, // 22

	STAT_DEC_FAT,			// 23
	STAT_DEC_BODY_MUSCLE,
	STAT_DEC_MAX_HEALTH,	// 25
	
	STAT_EXERCISE_RATE_CYCLE,		// 26
	STAT_EXERCISE_RATE_CYCLE_SPRINT,
	STAT_EXERCISE_RATE_SWIM,
	STAT_EXERCISE_RATE_SWIM_SPRINT,
	STAT_EXERCISE_RATE_SPRINT,
	STAT_EXERCISE_RATE_RUN,
	STAT_EXERCISE_RATE_FIGHT,		// 32
	
	//
	// time intervals when the stats get changed (in sec?):
	//
	STAT_TIMELIMIT_CYCLE_STAMINA,		// 33
	STAT_TIMELIMIT_SWIM_STAMINA,
	STAT_TIMELIMIT_SPRINT_STAMINA,
	STAT_TIMELIMIT_RUNNING,
	STAT_TIMELIMIT_DRIVING_SKILL,
	STAT_TIMELIMIT_FLYING_SKILL,
	STAT_TIMELIMIT_CYCLE_SKILL,
	STAT_TIMELIMIT_MOTORBIKE_SKILL,
	STAT_TIMELIMIT_BOAT_SKILL,
	STAT_TIMELIMIT_FAT_ADJUST,
	STAT_TIMELIMIT_FAT_ADJUST_STRENUOUS,
	STAT_TIMELIMIT_BREATH_UNDERWATER,
	STAT_TIMELIMIT_MAX_HEALTH,			// 45
	
	//
	// limits that are not time (ie count limits):
	//
	STAT_TIMELIMIT_PISTOL_SKILL,		// 46
	STAT_TIMELIMIT_PISTOL_SILENCED_SKILL,
	STAT_TIMELIMIT_DESERT_EAGLE_SKILL,
	STAT_TIMELIMIT_SHOTGUN_SKILL,
	STAT_TIMELIMIT_SAWNOFF_SHOTGUN_SKILL,
	STAT_TIMELIMIT_SPAS12_SHOTGUN_SKILL,
	STAT_TIMELIMIT_MICRO_UZI_SKILL,
	STAT_TIMELIMIT_MP5_SKILL,
	STAT_TIMELIMIT_M4_SKILL,
	STAT_TIMELIMIT_AK47_SKILL,
	STAT_TIMELIMIT_SNIPERRIFLE_SKILL,	// 56

	// every time player dies and gets respawned we count it up
	// so we can decrement max health 
	STAT_TIMELIMIT_DEATH_HEALTH,	// 57
	// every time player adds to their health we count it up
	// so this limit is a direct amount of health added
	STAT_TIMELIMIT_ADD_TO_HEALTH,	// 58
	
	MAX_REACTION_STATS
};	

#define MAX_INT_STATS (MAX_INT_FLOAT_STATS - STATS_OFFSET)
#define MAX_STATS (MAX_INT_STATS + MAX_FLOAT_STATS)

enum eWeaponType;

class CStats
{
public:
	virtual float	        GetStatValue        ( unsigned short usIndex ) = 0;
	virtual void	        ModifyStat          ( unsigned short usIndex, float fAmmount ) = 0;
	virtual void	        IncrementStat       ( unsigned short usIndex, float fAmmount ) = 0;
	virtual void	        DecrementStat       ( unsigned short usIndex, float fAmmount ) = 0;
	virtual void	        SetStatValue        ( unsigned short usIndex, float fAmmount ) = 0;

    virtual unsigned short  GetSkillStatIndex   ( eWeaponType type ) = 0;
};

#endif