//Engine Blow Out v0.2

using System;
using System.IO;
using System.Collections.Generic;
using System.Windows.Forms;
using GTA;

public class EBO : Script
{
    //Customization Variables
    float gracePeriod = 25.0f;          //The Grace Period is the amount of time you have before damage takes place from overheating, this isn't in seconds or time format- you'll have to play with it.
    float cooldownModifier = 0.2f;   //This is a cooldown modifier- the number reflects at what rpm cooling stops and overheating resumes- be sure to change the 'overheatModifier' to match this. See Readme for help.
    float overheatModifier = 0.8f;     //Directly relates to ingame RPM, a value of 0 is stopped, 1 is maxed out.
    //End Customization Variables

    //Edit everything below at your own risk. (But really, its not too hard to understand what it does.)
    float engineHealth;
    float engineRPM;
    float blowOutTime = 0.0f;

    public EBO()
    {
        this.Tick += new EventHandler(BlowOut);
    }

    private void BlowOut(object sender, EventArgs e)
    {
        if (Player.Character.isInVehicle())
        {
            engineRPM = Player.Character.CurrentVehicle.CurrentRPM;
            engineHealth = Player.Character.CurrentVehicle.EngineHealth;

            if (Player.Character.CurrentVehicle.CurrentRPM >= overheatModifier)
            {
                blowOutTime = (blowOutTime + ((engineRPM / 10) * engineRPM));
            }
            else
            {
                if (blowOutTime > 0.0)
                {
                    blowOutTime = blowOutTime - (cooldownModifier - (engineRPM / 4));
                }
            }

            if (blowOutTime > gracePeriod)
            {
                if (engineHealth > 0.0)
                {
                    engineHealth = engineHealth - (blowOutTime * (engineRPM / 10));
                    Player.Character.CurrentVehicle.EngineHealth = engineHealth;
                }
                else
                {

                    engineHealth = 0.0f;
                    Player.Character.CurrentVehicle.EngineHealth = engineHealth;
                }
            }
        }
        else
        {
            blowOutTime = 0;
        }
    }

}